// "use client";

// import * as React from "react";
// import { useSearchParams } from "next/navigation";
// import { doc, getDoc } from "firebase/firestore";

// import { getAccessItem } from "@/lib/access/catalog";
// import PayButton from "@/components/access/PayButton";
// import DownloadButton from "@/components/access/DownloadButton";

// import { db } from "@/lib/firebaseClient";
// import { useUserProfile, type UserProfile } from "@/hooks/useUserProfile";
// import ReceiptButton from "@/components/access/ReceiptButton";


// export default function GoPage() {
//   const searchParams = useSearchParams();
//   const sku = searchParams.get("sku");
//   const next = searchParams.get("next"); // optional

//   const item = getAccessItem(sku);

//   const { loading, firebaseUser, profile, loginWithGoogle, logout } =
//     useUserProfile();

//   const [localProfile, setLocalProfile] = React.useState<UserProfile | null>(
//     null
//   );

//   const effectiveProfile = localProfile ?? profile;
//   const hasFullAccess = Boolean(effectiveProfile?.hasFullAccess);

//   // keep localProfile synced with hook profile
//   React.useEffect(() => {
//     setLocalProfile(profile);
//   }, [profile]);

//   async function reloadProfileOnce() {
//     if (!firebaseUser) return;

//     const ref = doc(db, "users", firebaseUser.uid);
//     const snap = await getDoc(ref);
//     const data = snap.exists() ? (snap.data() as any) : null;

//     const updated: UserProfile = {
//       uid: firebaseUser.uid,
//       email: data?.email ?? firebaseUser.email ?? null,
//       name: data?.name ?? firebaseUser.displayName ?? null,
//       hasFullAccess: !!data?.hasFullAccess,
//     };

//     setLocalProfile(updated);
//   }

//   if (!item) {
//     return (
//       <div className="max-w-xl mx-auto p-6">
//         <h1 className="text-2xl font-bold">Invalid link</h1>
//         <p className="mt-2 text-gray-600">
//           This link is not valid. Please go back and try again.
//         </p>
//       </div>
//     );
//   }

//   return (
//     <div className="max-w-xl mx-auto p-6">
//       <div className="border rounded-lg p-5">
//         <h1 className="text-2xl font-bold">{item.title}</h1>

//         {item.description && (
//           <p className="mt-2 text-gray-600">{item.description}</p>
//         )}

//         <div className="mt-6 space-y-4">
//           {!firebaseUser ? (
//             <button
//               onClick={loginWithGoogle}
//               disabled={loading}
//               className="px-4 py-2 rounded-md text-white bg-blue-600 hover:bg-blue-700"
//             >
//               {loading ? "Loading..." : "Sign in with Google"}
//             </button>
//           ) : (
//             <>
//               <div className="text-sm text-gray-700">
//                 Signed in as <b>{firebaseUser.email}</b>
//               </div>

//               {!hasFullAccess ? (
//                 <div className="space-y-3">
//                   <div className="text-sm text-gray-600">
//                     Status: <b className="text-red-600">Not purchased</b>
//                   </div>

//                   <PayButton
//                     amount={10}
//                     onSuccess={async () => {
//                       // verify-payment updates Firestore, so reload once
//                       await reloadProfileOnce();
//                     }}
//                   />
//                 </div>
//               ) : (
//                 <div className="space-y-3">
//                   <div className="text-sm text-gray-600">
//                     Status: <b className="text-green-600">Purchased</b>
//                   </div>

//                   <DownloadButton sku={item.sku} />
//                 </div>
//               )}

//               <button
//                 onClick={logout}
//                 className="text-sm text-gray-500 underline"
//               >
//                 Logout
//               </button>
//             </>
//           )}

//           {next && (
//             <div className="pt-4 border-t text-sm text-gray-600">
//               After success, continue to: <span className="font-mono">{next}</span>
//             </div>
//           )}
//         </div>
//       </div>
//     </div>
//   );
// }



"use client";

import * as React from "react";
import { useSearchParams } from "next/navigation";
import { doc, getDoc } from "firebase/firestore";

import { getAccessItem } from "@/lib/access/catalog";
import PayButton from "@/components/access/PayButton";
import DownloadButton from "@/components/access/DownloadButton";
import ReceiptButton from "@/components/access/ReceiptButton";

import { db } from "@/lib/firebaseClient";
import { useUserProfile, type UserProfile } from "@/hooks/useUserProfile";

export default function GoPage() {
  const searchParams = useSearchParams();
  const sku = searchParams.get("sku");

  const item = getAccessItem(sku);

  const {
    loading,
    firebaseUser,
    profile,
    loginWithGoogle,
    logout,
  } = useUserProfile();

  const [localProfile, setLocalProfile] = React.useState<UserProfile | null>(null);

  const effectiveProfile = localProfile ?? profile;
  const hasFullAccess = Boolean(effectiveProfile?.hasFullAccess);

  React.useEffect(() => {
    setLocalProfile(profile);
  }, [profile]);

  async function reloadProfileOnce() {
    if (!firebaseUser) return;

    const ref = doc(db, "users", firebaseUser.uid);
    const snap = await getDoc(ref);
    if (!snap.exists()) return;

    const data = snap.data() as any;

    const updated: UserProfile = {
      uid: firebaseUser.uid,
      email: data.email ?? firebaseUser.email ?? null,
      name: data.name ?? firebaseUser.displayName ?? null,
      hasFullAccess: !!data.hasFullAccess,
      lastPaymentId: data.lastPaymentId ?? undefined,
    };

    setLocalProfile(updated);
  }

  if (!item) {
    return (
      <div className="max-w-xl mx-auto p-6">
        <h1 className="text-2xl font-bold">Invalid link</h1>
        <p className="mt-2 text-gray-600">
          This link is not valid. Please go back and try again.
        </p>
      </div>
    );
  }

  return (
    <div className="max-w-xl mx-auto p-6">
      <div className="border rounded-lg p-5">
        <h1 className="text-2xl font-bold">{item.title}</h1>

        {item.description && (
          <p className="mt-2 text-gray-600">{item.description}</p>
        )}

        <div className="mt-6 space-y-4">
          {!firebaseUser ? (
            <button
              onClick={loginWithGoogle}
              disabled={loading}
              className="px-4 py-2 rounded-md text-white bg-blue-600 hover:bg-blue-700"
            >
              {loading ? "Loading..." : "Sign in with Google"}
            </button>
          ) : (
            <>
              <div className="text-sm text-gray-700">
                Signed in as <b>{firebaseUser.email}</b>
              </div>

              {!hasFullAccess ? (
                <div className="space-y-3">
                  <div className="text-sm text-gray-600">
                    Status: <b className="text-red-600">Not purchased</b>
                  </div>

                  <PayButton
                    amount={1}
                    onSuccess={async () => {
                      await reloadProfileOnce();
                    }}
                  />
                </div>
              ) : (
                <div className="space-y-3">
                  <div className="text-sm text-gray-600">
                    Status: <b className="text-green-600">Purchased</b>
                  </div>

                  <DownloadButton sku={item.sku} />

                  {effectiveProfile?.lastPaymentId && (
                    <ReceiptButton paymentId={effectiveProfile.lastPaymentId} />
                  )}
                </div>
              )}

              <button
                onClick={logout}
                className="text-sm text-gray-500 underline"
              >
                Logout
              </button>
            </>
          )}
        </div>
      </div>
    </div>
  );
}
