
import React from "react";
import Image from "next/image";
import Link from "next/link";
import RoadmapSection from "@/components/roadmap_section";
import BrandPromiseSection from "@/components/BrandPromiseSection";
// import LearnWithUsSection from "@/components/LearnWithUsSection";
import TestimonialsSection from "@/components/TestimonialsSection_2";
import Header from "@/components/header_2";
import Footer from "@/components/footer_2";
import MentorSection from "@/components/MentorSection";

const PRIMARY_BLUE = "bg-blue-600 hover:bg-blue-700";
const PRIMARY_BLUE_TEXT =
  "text-blue-600 border-blue-600 hover:bg-blue-50 hover:text-blue-700";

export default function HomePage() {
  return (
    <main className="bg-white">
      <Header />
      <HeroSection />
      {/* <OfferingsSection /> */}
      <RoadmapSection />
      <BrandPromiseSection />
      {/* <LearnWithUsSection/> */}
      <TestimonialsSection/>
      <MentorSection/>
      <Footer/>
    </main>
  );
}

/* 1st Fold – Nanki photo + Making Economy Simple (tagline) */
function FirstFold() {
  return (
    <section className="bg-white border-b border-gray-100">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-5">
        <div className="flex items-center gap-3 sm:gap-4">
          {/* Small Nanki photo */}
          <div className="relative h-10 w-10 sm:h-12 sm:w-12 rounded-full overflow-hidden shadow-[0_6px_14px_rgba(0,0,0,0.15)]">
            <Image
              src="/nankinomics-logo-3.png" // update if different
              alt="Nanki Baweja"
              fill
              className="object-cover"
              sizes="48px"
            />
          </div>

          {/* Tagline */}
          <p className="text-sm sm:text-base font-medium text-gray-800">
            Making Economy Simple
          </p>
        </div>
      </div>
    </section>
  );
}


function HeroSection() {
  return (
    <section className="bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-center gap-10 lg:gap-16 pt-12 pb-12 lg:pt-32 lg:pb-24">
          
          {/* Left Column */}
          <div className="w-full lg:w-7/12 order-2 lg:order-1">
            <h1 className="text-4xl sm:text-5xl font-semibold text-[#1A1A1A] max-w-xl">
              A structured system to finally master UPSC Economics.
            </h1>

            <p className="mt-4 text-lg sm:text-xl font-normal text-[#4A4A4A] max-w-lg leading-relaxed">
              Economics doesn’t have to feel overwhelming.
              We help you build concepts step by step — from NCERT basics to current affairs and exam readiness — so things actually start making sense.
            </p>

            <ul className="mt-5 space-y-2 text-[17px] text-[#374151]">
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>Learn Economics in language you actually understand</span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>Worksheet-driven learning to capture and revise concepts</span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>Connect every topic with weekly current affairs</span>
              </li>
            </ul>

            {/* CTAs */}
            <div className="mt-6 flex flex-col sm:flex-row gap-3 sm:gap-4">
              <Link
                href="/weekly-current-affairs"
                className={`inline-flex items-center justify-center px-6 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors`}
              >
                Explore Economy Current Affairs
              </Link>

              <Link
                href="/ncert-course"
                className={`inline-flex items-center justify-center px-5 py-3 rounded-lg text-sm sm:text-base font-semibold border-2 ${PRIMARY_BLUE_TEXT} transition-colors`}
              >
                Start NCERT Economy
              </Link>
            </div>

            {/* 🔹 Helper Line Below Buttons */}
            <div className="mt-4 text-sm text-[#4B5563]">
              Confused about what to study in Economy?{" "}

              <span
                className="inline-flex items-center gap-2 px-2 py-1 rounded-md 
                          bg-gray-100 text-gray-400 font-semibold cursor-not-allowed"
                aria-disabled="true"
              >
                Explore Economy Decoded (Syllabus Navigator)

                {/* Coming Soon Tag */}
                <span className="text-[10px] px-1.5 py-0.5 rounded bg-gray-300 text-gray-700 uppercase tracking-wide">
                  Coming Soon
                </span>

                <span className="opacity-50">→</span>
              </span>
            </div>

          </div>

          {/* Right Column – Image */}
          <div className="w-full lg:w-5/12 order-1 lg:order-2 flex justify-center lg:justify-end">
            <div className="relative w-full max-w-sm mx-auto lg:mr-4">
              <div className="relative h-[500px] sm:h-[560px] lg:h-[620px] rounded-2xl bg-white shadow-[0_10px_25px_rgba(0,0,0,0.15)] overflow-hidden">
                <Image
                  src="/nanki_sitting.jpeg"
                  alt="Nanki Baweja - Nankinomics"
                  fill
                  className="object-cover"
                  priority
                />
              </div>
            </div>
          </div>

        </div>
      </div>
    </section>
  );
}





/* Today’s Offerings Section */
function OfferingsSection() {
  return (
    <section className="bg-white py-16 sm:py-20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section Title */}
        <div className="mb-8 sm:mb-10">
          <h2 className="text-2xl sm:text-3xl font-semibold text-[#1A1A1A]">
            Today’s Offerings
          </h2>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-8">
          {/* Card 1 – Economy Weekly (Free Program) */}
          <Card>
            <CardTitle>Economy Weekly (Free Program)</CardTitle>

            <CardSubtitle>
              Stay updated without feeling overwhelmed — your weekly anchor for
              UPSC Economy.
            </CardSubtitle>

            <CardSectionTitle>Benefits:</CardSectionTitle>
            <CardList items={[
              "Live every weekend with simplified Economy news",
              "Weekly worksheets that convert news into understanding",
              "Clear static ↔ current linkage for Prelims & Mains",
            ]} />

            <CardSectionTitle>Deliverables:</CardSectionTitle>
            <CardList
              items={[
                "1 weekly live session",
                "1 worksheet (PDF)",
                "Syllabus-mapped current affairs digest",
              ]}
              dash
            />

            <div className="mt-5">
              <Link
                href="/economy-weekly"
                className={`inline-flex items-center justify-center px-6 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors`}
              >
                Join Economy Weekly — Free
              </Link>
            </div>
          </Card>

          {/* Card 2 – NCERT Course (Free + Paid, Highlight border) */}
          <Card highlight>
            <CardTitle>NCERT Course (Free + Paid)</CardTitle>

            <CardSubtitle>
              Build your Economy foundation the smart way — clear classes,
              guided worksheets, and structured practice.
            </CardSubtitle>

            <CardSectionTitle>Benefits:</CardSectionTitle>
            <CardList
              items={[
                "Free YouTube lectures for every NCERT chapter",
                "Worksheets that turn concepts into ready-made notes",
                "Chapter-wise MCQs for active recall and confidence",
              ]}
            />

            <CardSectionTitle>Deliverables:</CardSectionTitle>
            <CardList
              items={[
                "Full NCERT video lectures (free)",
                "Worksheets + MCQs + revision pack (₹499)",
                "Summary sheets for quick revision",
              ]}
              dash
            />

            <div className="mt-5">
              <Link
                href="/ncert-course"
                className={`inline-flex items-center justify-center px-5 py-3 rounded-lg text-sm sm:text-base font-semibold border-2 ${PRIMARY_BLUE_TEXT} transition-colors`}
              >
                Start NCERT Course — Free Classes
              </Link>
            </div>
          </Card>
        </div>
      </div>
    </section>
  );
}

/* Shared Card components */

type CardProps = {
  children: React.ReactNode;
  highlight?: boolean;
};

function Card({ children, highlight }: CardProps) {
  return (
    <div
      className={[
        "h-full flex flex-col bg-white rounded-2xl shadow-[0_10px_30px_rgba(0,0,0,0.06)]",
        highlight
          ? "border-[3px] border-blue-600 p-[29px]" // 32px inner with 3px border
          : "border border-gray-200 p-8",
      ].join(" ")}
    >
      {children}
    </div>
  );
}

function CardTitle({ children }: { children: React.ReactNode }) {
  return (
    <h3 className="text-2xl sm:text-[26px] font-semibold text-[#1A1A1A]">
      {children}
    </h3>
  );
}

function CardSubtitle({ children }: { children: React.ReactNode }) {
  // ~8–12px below title
  return (
    <p className="mt-3 text-[17px] text-[#4A4A4A] leading-relaxed">
      {children}
    </p>
  );
}

function CardSectionTitle({ children }: { children: React.ReactNode }) {
  // ~16px above section
  return (
    <p className="mt-4 text-sm font-semibold tracking-wide uppercase text-gray-500">
      {children}
    </p>
  );
}

function CardList({
  items,
  dash = false,
}: {
  items: string[];
  dash?: boolean;
}) {
  return (
    <ul className="mt-3 space-y-1.5 text-[16px] text-[#374151]">
      {items.map((item, idx) => (
        <li key={idx} className="flex gap-2">
          <span className="mt-[6px] text-xs">{dash ? "–" : "•"}</span>
          <span>{item}</span>
        </li>
      ))}
    </ul>
  );
}
