// // // import { NextResponse } from "next/server";
// // // import type { NextRequest } from "next/server";
// // // import PDFDocument from "pdfkit";
// // // // import PDFDocument = require("pdfkit");


// // // import { adminDb } from "@/lib/firebaseAdmin";
// // // import { requireFirebaseUser } from "@/lib/auth/requireIdToken";

// // // export async function GET(req: NextRequest) {
// // //   const { searchParams } = new URL(req.url);
// // //   const paymentId = searchParams.get("paymentId");

// // //   if (!paymentId) {
// // //     return NextResponse.json({ ok: false, error: "Missing paymentId" }, { status: 400 });
// // //   }

// // //   const user = await requireFirebaseUser(req);
// // //   if (!user.ok) {
// // //     return NextResponse.json({ ok: false, error: user.error }, { status: 401 });
// // //   }

// // //   const db = adminDb();
// // //   const paySnap = await db.collection("payments").doc(paymentId).get();

// // //   if (!paySnap.exists) {
// // //     return NextResponse.json({ ok: false, error: "Receipt not found" }, { status: 404 });
// // //   }

// // //   const pay = paySnap.data() as any;

// // //   // ✅ Ownership check: user can only download their own receipt
// // //   if (pay.uid !== user.uid) {
// // //     return NextResponse.json({ ok: false, error: "Forbidden" }, { status: 403 });
// // //   }

// // //   // --- Generate PDF ---
// // //   const doc = new PDFDocument({ size: "A4", margin: 50 });

// // //   const chunks: Buffer[] = [];
// // //   doc.on("data", (c) => chunks.push(c));
// // //   const pdfDone = new Promise<Buffer>((resolve) => {
// // //     doc.on("end", () => resolve(Buffer.concat(chunks)));
// // //   });

// // //   doc.fontSize(18).text("Nankinomics — Payment Receipt", { align: "center" });
// // //   doc.moveDown(1);

// // //   doc.fontSize(12);
// // //   doc.text(`Receipt Date: ${new Date(pay.paidAt || Date.now()).toLocaleString()}`);
// // //   doc.text(`Customer UID: ${pay.uid}`);
// // //   doc.moveDown(0.5);

// // //   doc.text(`Payment ID: ${pay.paymentId}`);
// // //   doc.text(`Order ID: ${pay.orderId}`);
// // //   doc.text(`Amount: ${pay.amount ? `₹${pay.amount}` : "₹—"}`);
// // //   doc.text(`Currency: ${pay.currency || "INR"}`);
// // //   doc.text(`Status: ${pay.status || "verified"}`);

// // //   doc.moveDown(1);
// // //   doc.text("Thank you for your purchase!", { align: "left" });

// // //   doc.end();

// // //   const pdf = await pdfDone;

// // //   const arrayBuffer = pdf.buffer.slice(pdf.byteOffset, pdf.byteOffset + pdf.byteLength);


// // //   return new NextResponse(arrayBuffer, {
// // //     status: 200,
// // //     headers: {
// // //       "Content-Type": "application/pdf",
// // //       "Content-Disposition": `attachment; filename="receipt-${paymentId}.pdf"`,
// // //     },
// // //   });

// // // }


// // // app/api/receipt/route.ts
// // export const runtime = "nodejs";

// // import { NextResponse } from "next/server";
// // import type { NextRequest } from "next/server";
// // import PDFDocument from "pdfkit";

// // import { adminDb } from "@/lib/firebaseAdmin";
// // import { requireFirebaseUser } from "@/lib/auth/requireIdToken";

// // export async function GET(req: NextRequest) {
// //   try {
// //     const { searchParams } = new URL(req.url);
// //     const paymentId = searchParams.get("paymentId");

// //     if (!paymentId) {
// //       return NextResponse.json(
// //         { ok: false, error: "Missing paymentId" },
// //         { status: 400 }
// //       );
// //     }

// //     // ✅ Auth check (Bearer token)
// //     const user = await requireFirebaseUser(req);
// //     if (!user.ok) {
// //       return NextResponse.json(
// //         { ok: false, error: user.error },
// //         { status: 401 }
// //       );
// //     }

// //     // ✅ Fetch payment doc
// //     const db = adminDb();
// //     const paySnap = await db.collection("payments").doc(paymentId).get();

// //     if (!paySnap.exists) {
// //       return NextResponse.json(
// //         { ok: false, error: "Receipt not found" },
// //         { status: 404 }
// //       );
// //     }

// //     const pay = paySnap.data() as any;

// //     // ✅ Ownership check
// //     if (pay.uid !== user.uid) {
// //       return NextResponse.json(
// //         { ok: false, error: "Forbidden" },
// //         { status: 403 }
// //       );
// //     }

// //     // ✅ Generate PDF into a Buffer
// //     const doc = new PDFDocument({ size: "A4", margin: 50 });

// //     const chunks: Buffer[] = [];
// //     doc.on("data", (c: Buffer) => chunks.push(c));

// //     const pdfBufferPromise = new Promise<Buffer>((resolve) => {
// //       doc.on("end", () => resolve(Buffer.concat(chunks)));
// //     });

// //     doc.fontSize(18).text("Nankinomics — Payment Receipt", { align: "center" });
// //     doc.moveDown(1);

// //     doc.fontSize(12);
// //     doc.text(
// //       `Receipt Date: ${new Date(pay.paidAt || Date.now()).toLocaleString()}`
// //     );
// //     doc.text(`Customer UID: ${pay.uid}`);
// //     doc.moveDown(0.5);

// //     doc.text(`Payment ID: ${pay.paymentId || paymentId}`);
// //     doc.text(`Order ID: ${pay.orderId || "-"}`);
// //     doc.text(`Amount: ${typeof pay.amount === "number" ? `₹${pay.amount}` : "₹—"}`);
// //     doc.text(`Currency: ${pay.currency || "INR"}`);
// //     doc.text(`Status: ${pay.status || "verified"}`);

// //     doc.moveDown(1);
// //     doc.text("Thank you for your purchase!");
// //     doc.end();

// //     const pdf = await pdfBufferPromise;

// //     // ✅ TS-friendly BodyInit: Uint8Array (avoids SharedArrayBuffer typing issue)
// //     const body = new Uint8Array(pdf);

// //     return new NextResponse(body, {
// //       status: 200,
// //       headers: {
// //         "Content-Type": "application/pdf",
// //         "Content-Disposition": `attachment; filename="receipt-${paymentId}.pdf"`,
// //         "Cache-Control": "no-store",
// //       },
// //     });
// //   } catch (e) {
// //     console.error("Receipt generation error:", e);
// //     if (e instanceof Error) {
// //       console.error("Message:", e.message);
// //       console.error("Stack:", e.stack);
// //     }

// //     return NextResponse.json(
// //       { ok: false, error: "Failed to generate receipt" },
// //       { status: 500 }
// //     );
// //   }
// // }





// // app/api/receipt/route.ts
// export const runtime = "nodejs";

// import { NextResponse } from "next/server";
// import type { NextRequest } from "next/server";
// import { PDFDocument, StandardFonts } from "pdf-lib";

// import { adminDb } from "@/lib/firebaseAdmin";
// import { requireFirebaseUser } from "@/lib/auth/requireIdToken";

// export async function GET(req: NextRequest) {
//   try {
//     const { searchParams } = new URL(req.url);
//     const paymentId = searchParams.get("paymentId");

//     if (!paymentId) {
//       return NextResponse.json(
//         { ok: false, error: "Missing paymentId" },
//         { status: 400 }
//       );
//     }

//     // ✅ Auth check
//     const user = await requireFirebaseUser(req);
//     if (!user.ok) {
//       return NextResponse.json(
//         { ok: false, error: user.error },
//         { status: 401 }
//       );
//     }

//     // ✅ Fetch payment doc
//     const db = adminDb();
//     const paySnap = await db.collection("payments").doc(paymentId).get();

//     if (!paySnap.exists) {
//       return NextResponse.json(
//         { ok: false, error: "Receipt not found" },
//         { status: 404 }
//       );
//     }

//     const pay = paySnap.data() as any;

//     // ✅ Ownership check
//     if (pay.uid !== user.uid) {
//       return NextResponse.json(
//         { ok: false, error: "Forbidden" },
//         { status: 403 }
//       );
//     }

//     // ✅ Build PDF using pdf-lib (no Helvetica.afm dependency)
//     const pdfDoc = await PDFDocument.create();
//     const page = pdfDoc.addPage([595.28, 841.89]); // A4 size in points
//     const font = await pdfDoc.embedFont(StandardFonts.Helvetica);
//     const bold = await pdfDoc.embedFont(StandardFonts.HelveticaBold);

//     const marginLeft = 50;
//     let y = 790;

//     page.drawText("Nankinomics — Payment Receipt", {
//       x: marginLeft,
//       y,
//       size: 18,
//       font: bold,
//     });

//     y -= 40;

//     const receiptDate = new Date(pay.paidAt || Date.now()).toLocaleString();

//     const lines = [
//       `Receipt Date: ${receiptDate}`,
//       `Customer UID: ${pay.uid}`,
//       "",
//       `Payment ID: ${pay.paymentId || paymentId}`,
//       `Order ID: ${pay.orderId || "-"}`,
//       `Amount: ${typeof pay.amount === "number" ? `${pay.amount} INR` : "— INR"}`,
//       `Currency: ${pay.currency || "INR"}`,
//       `Status: ${pay.status || "verified"}`,
//       "",
//       "Thank you for your purchase!",
//     ];


//     for (const line of lines) {
//       page.drawText(line, {
//         x: marginLeft,
//         y,
//         size: 12,
//         font,
//       });
//       y -= 18;
//     }

//     return new Response(`
//     <html>
//       <head>
//         <title>Payment Receipt</title>
//         <style>
//           body { font-family: Arial; padding: 40px; }
//           h1 { margin-bottom: 20px; }
//           .row { margin-bottom: 8px; }
//         </style>
//       </head>
//       <body>
//         <h1>Nankinomics – Payment Receipt</h1>
//         <div class="row"><b>Payment ID:</b> ${paymentId}</div>
//         <div class="row"><b>Order ID:</b> ${pay.orderId}</div>
//         <div class="row"><b>Amount:</b> ₹${pay.amount}</div>
//         <div class="row"><b>Status:</b> ${pay.status}</div>
//         <div class="row"><b>Date:</b> ${new Date(pay.paidAt).toLocaleString()}</div>
//         <br/>
//         <p>Thank you for your purchase.</p>
//       </body>
//     </html>
//   `, {
//     headers: { "Content-Type": "text/html" }
//   });

//   } catch (e) {
//     console.error("Receipt generation error:", e);
//     return NextResponse.json(
//       { ok: false, error: "Failed to generate receipt" },
//       { status: 500 }
//     );
//   }
// }


// app/api/receipt/route.ts
// ✅ HTML receipt (print/save as PDF in browser)
// ✅ No Authorization header required (so window.open works)
// ✅ Node runtime (Firestore Admin)
// ✅ Error-safe responses

export const runtime = "nodejs";

import type { NextRequest } from "next/server";
import { adminDb } from "@/lib/firebaseAdmin";

function escapeHtml(v: any) {
  const s = String(v ?? "");
  return s
    .replaceAll("&", "&amp;")
    .replaceAll("<", "&lt;")
    .replaceAll(">", "&gt;")
    .replaceAll('"', "&quot;")
    .replaceAll("'", "&#39;");
}

export async function GET(req: NextRequest) {
  try {
    const { searchParams } = new URL(req.url);
    const paymentId = searchParams.get("paymentId");

    if (!paymentId) {
      return new Response(
        JSON.stringify({ ok: false, error: "Missing paymentId" }),
        {
          status: 400,
          headers: { "Content-Type": "application/json" },
        }
      );
    }

    const db = adminDb();
    const paySnap = await db.collection("payments").doc(paymentId).get();

    if (!paySnap.exists) {
      return new Response(
        JSON.stringify({ ok: false, error: "Receipt not found" }),
        {
          status: 404,
          headers: { "Content-Type": "application/json" },
        }
      );
    }

    const pay = paySnap.data() as any;

    const paidAt = pay?.paidAt
      ? new Date(pay.paidAt).toLocaleString()
      : new Date().toLocaleString();

    const orderId = escapeHtml(pay?.orderId || "-");
    const paymentIdSafe = escapeHtml(pay?.paymentId || paymentId);
    const status = escapeHtml(pay?.status || "verified");
    const currency = escapeHtml(pay?.currency || "INR");

    // Use "INR" text to avoid unicode font issues in server-side PDF libs
    const amount =
      typeof pay?.amount === "number" ? `${pay.amount} INR` : `— INR`;

    const uid = escapeHtml(pay?.uid || "-");

    const html = `<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Payment Receipt - Nankinomics</title>
  <style>
    :root { color-scheme: light; }
    body { font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; margin: 0; background:#f6f7fb; }
    .wrap { max-width: 820px; margin: 32px auto; padding: 0 16px; }
    .card { background: white; border: 1px solid #e6e8ef; border-radius: 14px; padding: 24px; box-shadow: 0 6px 18px rgba(0,0,0,.05); }
    h1 { font-size: 20px; margin: 0 0 12px; }
    .sub { color:#5b6472; font-size: 13px; margin-bottom: 20px; }
    .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 12px 18px; }
    .row { padding: 10px 12px; border: 1px solid #eef0f6; border-radius: 10px; background: #fbfcff; }
    .k { font-size: 12px; color:#6b7280; margin-bottom: 4px; }
    .v { font-size: 14px; color:#111827; word-break: break-word; }
    .footer { margin-top: 18px; display:flex; align-items:center; justify-content: space-between; gap: 12px; flex-wrap: wrap; }
    .btn { border: 0; border-radius: 10px; padding: 10px 14px; background: #111827; color: white; cursor: pointer; }
    .note { color:#6b7280; font-size: 12px; }
    @media print {
      body { background: white; }
      .wrap { margin: 0; max-width: none; padding: 0; }
      .card { border: 0; box-shadow: none; border-radius: 0; }
      .btn, .note { display:none; }
    }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>Nankinomics — Payment Receipt</h1>
      <div class="sub">You can print this page and “Save as PDF”.</div>

      <div class="grid">
        <div class="row">
          <div class="k">Receipt Date</div>
          <div class="v">${escapeHtml(paidAt)}</div>
        </div>
        <div class="row">
          <div class="k">Status</div>
          <div class="v">${status}</div>
        </div>

        <div class="row">
          <div class="k">Payment ID</div>
          <div class="v">${paymentIdSafe}</div>
        </div>
        <div class="row">
          <div class="k">Order ID</div>
          <div class="v">${orderId}</div>
        </div>

        <div class="row">
          <div class="k">Amount</div>
          <div class="v">${escapeHtml(amount)}</div>
        </div>
        <div class="row">
          <div class="k">Currency</div>
          <div class="v">${currency}</div>
        </div>

        <div class="row" style="grid-column: 1 / -1;">
          <div class="k">User UID</div>
          <div class="v">${uid}</div>
        </div>
      </div>

      <div class="footer">
        <button class="btn" onclick="window.print()">Print / Save as PDF</button>
        <div class="note">For support, share your Payment ID and Order ID.</div>
      </div>
    </div>
  </div>
</body>
</html>`;

    return new Response(html, {
      status: 200,
      headers: {
        "Content-Type": "text/html; charset=utf-8",
        "Cache-Control": "no-store",
      },
    });
  } catch (e) {
    console.error("Receipt route error:", e);
    return new Response(
      JSON.stringify({ ok: false, error: "Failed to generate receipt" }),
      {
        status: 500,
        headers: { "Content-Type": "application/json" },
      }
    );
  }
}
