// app/weekly-current-affairs/page.tsx
// Economy Current Affairs (Weekly) — Nankinomics
// Built STRICTLY from the text you provided, with the same visual language as your home page.

import Image from "next/image"
import Link from "next/link"

import WeeklyArchiveSection from "@/components/weekly-ca/WeeklyArchiveSection";
import { HeroLatestYouTubeButton, HeroLatestYouTubeThumbnail } from "@/components/weekly-ca/HeroLatest";

import Header from "@/components/header_2";
import Footer from "@/components/footer_2";





const PRIMARY_BLUE = "bg-blue-600 hover:bg-blue-700"
const HOVER_ANIM =
  "inline-flex transform-gpu transition-all duration-200 ease-out hover:-translate-y-0.5 hover:scale-[1.02] hover:shadow-md active:translate-y-0 active:scale-[0.99] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-blue-500 focus-visible:ring-offset-2"


// ✅ Replace this with the latest Economy Weekly YouTube video URL
// const LATEST_ECONOMY_WEEKLY_YT_URL = "https://www.youtube.com/live/CMlhZcDOnMw?si=APcBfjoY8Ds3kdZi"

// // ✅ Replace this with your Economy Weekly thumbnail image path (used in HERO right side)
// const ECONOMY_WEEKLY_THUMBNAIL_SRC = "/images/weekly-ca/economy-weekly-thumbnail.jpg"

export default function Page() {
  return (
    <main className="bg-white">
      <Header/>
      <HeroSection />
      <Section2_OverwhelmFix />
      <Section3_HowEconomyWeeklyWorks />
      <Section4_WorksheetsProof />
      <Section5_CalendarArchive />
      <Section6_FAQs />
      <Footer/>
    </main>
  )
}


function HeroSection() {
  return (
    <section className="bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-center gap-10 lg:gap-16 pt-12 pb-12 lg:pt-24 lg:pb-20">
          {/* LEFT (Text) */}
          <div className="w-full lg:w-7/12">
            <h1 className="text-4xl sm:text-5xl font-semibold text-[#1A1A1A]">
              Economy Current Affairs — Weekly, Structured, Exam-Focused
            </h1>

            <p className="mt-4 text-lg sm:text-xl font-normal text-[#4A4A4A] leading-relaxed max-w-2xl">
              Follow Economic Current Affairs for UPSC without overload — learn weekly
              through focused analysis and revise systematically using worksheets.
            </p>

            {/* Primary CTAs */}
            <div className="mt-6 flex flex-col sm:flex-row gap-3 sm:gap-4">
              {/* Browse Weeks -> scroll */}
              <a
                href="#weekly-archive"
                className={`inline-flex items-center justify-center px-6 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white bg-blue-600 hover:bg-blue-700 transition-colors ${HOVER_ANIM}`}
              >
                Browse Weeks
              </a>

              {/* Watch on YouTube -> latest weekly video (dynamic) */}
              <HeroLatestYouTubeButton />
            </div>

            {/* Secondary line */}
            <p className="mt-4 text-sm sm:text-base text-[#6B7280]">
              Each week includes a free YouTube session and a downloadable worksheet.
            </p>
          </div>

          {/* RIGHT (Visual) — latest thumbnail clickable (dynamic) */}
          <div className="w-full lg:w-5/12 flex justify-center lg:justify-end">
            <HeroLatestYouTubeThumbnail />
          </div>
        </div>
      </div>
    </section>
  );
}












/* -------------------------------------------------------
   SECTION 2 — FINAL COPY
   Heading + 2x2 chaos blocks + fix banner strip
   MUST fit in one scroll on desktop
   No CTAs, no steps/arrows, no merge with section 3
-------------------------------------------------------- */

function Section2_OverwhelmFix() {
  const chaos = [
    {
      h: "Too many sources",
      t: "Newspapers, PIB, reports, statements — no clear filter.",
    },
    {
      h: "No exam relevance",
      t: "News is read daily, but not converted into exam-ready points.",
    },
    {
      h: "Prelims vs Mains confusion",
      t: "Same issue, wrong depth — either overdone or underdone.",
    },
    {
      h: "No revision-ready notes",
      t: "Reading happens, but nothing usable remains for revision.",
    },
  ]

  return (
    <section className="bg-white py-14 sm:py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="max-w-3xl mx-auto text-center">
          <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
            Why Economic Current Affairs feel overwhelming for UPSC aspirants
          </h2>
        </div>

        {/* Chaos blocks: 2x2 grid desktop, stacked mobile. No icons. */}
        <div className="mt-10 grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-8">
          {chaos.map((b, i) => (
            <div
              key={i}
              className="bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8"
            >
              <p className="text-lg font-semibold text-[#111827]">{b.h}</p>
              <p className="mt-2 text-[15px] sm:text-[16px] text-[#4B5563] leading-relaxed">
                {b.t}
              </p>
            </div>
          ))}
        </div>

        {/* Fix Banner: full-width highlighted strip below chaos blocks */}
        <div className="mt-8 rounded-2xl bg-blue-50 border border-blue-100 p-7 sm:p-8">
          <p className="text-lg sm:text-xl font-semibold text-[#111827]">
            How Nankinomics fixes this
          </p>

          <p className="mt-3 text-[15px] sm:text-[16px] text-[#374151] leading-relaxed">
            Economy Weekly is a guided weekly current-affairs system where important
            economic issues are:
          </p>

          <ul className="mt-4 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
            <li className="flex gap-2">
              <span className="mt-[6px] text-sm">•</span>
              <span>selected with a clear UPSC lens</span>
            </li>
            <li className="flex gap-2">
              <span className="mt-[6px] text-sm">•</span>
              <span>taught through focused YouTube sessions</span>
            </li>
            <li className="flex gap-2">
              <span className="mt-[6px] text-sm">•</span>
              <span>converted into structured worksheets that become your notes</span>
            </li>
            <li className="flex gap-2">
              <span className="mt-[6px] text-sm">•</span>
              <span>easy to revise later for Prelims and Mains</span>
            </li>
          </ul>

          <p className="mt-5 text-[15px] sm:text-[16px] text-[#374151] leading-relaxed">
            You don’t chase news every day. You follow one weekly system and build
            revision-ready content consistently.
          </p>
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------------------
   SECTION 3 — How Economy Weekly works
   Left–Right Split (locked)
   - No cards/boxes/shaded backgrounds
   - No icons/checkmarks/arrows/steps/numbers
   - Bullet lines only; mirror both columns; equal weight
   - Optional closing line below, muted, not bold, not CTA
-------------------------------------------------------- */

function Section3_HowEconomyWeeklyWorks() {
  // Same number of bullet lines on both sides (mirrored)
  const leftBullets = [
    "You follow one weekly YouTube class focused only on important economy issues",
    "You fill a structured worksheet during the class",
    "The session stays exam-focused (no random news coverage)",
    "Each week is designed to be completed without overload",
  ]

  const rightBullets = [
    "You walk away with one clean worksheet for that week’s economy topic",
    "Your notes are ready without extra note-making after class",
    "You get revision-ready content for Prelims and Mains",
    "You build a consistent system week after week",
  ]

  return (
    <section className="bg-white py-14 sm:py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 className="text-center text-3xl sm:text-4xl font-semibold text-[#111827]">
          How Economy Weekly works
        </h2>

        <div className="mt-10 grid grid-cols-1 md:grid-cols-2 gap-10 lg:gap-16">
          {/* Left column */}
          <div>
            <p className="text-lg font-semibold text-[#111827]">
              What happens in the class
            </p>
            <ul className="mt-4 space-y-3 text-[15px] sm:text-[16px] text-[#374151] leading-relaxed">
              {leftBullets.map((line, idx) => (
                <li key={idx} className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>
                    {/* subtle emphasis only where allowed */}
                    {emphasizeYouTubeAndWorksheet(line)}
                  </span>
                </li>
              ))}
            </ul>
          </div>

          {/* Right column */}
          <div>
            <p className="text-lg font-semibold text-[#111827]">
              What the student walks away with
            </p>
            <ul className="mt-4 space-y-3 text-[15px] sm:text-[16px] text-[#374151] leading-relaxed">
              {rightBullets.map((line, idx) => (
                <li key={idx} className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>{emphasizeNotesReady(line)}</span>
                </li>
              ))}
            </ul>
          </div>
        </div>

        {/* Optional closing line */}
        <p className="mt-8 text-center text-sm sm:text-base text-[#6B7280]">
          One weekly system. Calm learning. Notes that stay usable till the exam.
        </p>
      </div>
    </section>
  )
}

function emphasizeYouTubeAndWorksheet(text: string) {
  // Subtle emphasis rule: “YouTube” and “structured worksheet” may be slightly emphasised
  const parts = text.split(/(YouTube|structured worksheet)/g)
  return (
    <>
      {parts.map((p, i) =>
        p === "YouTube" || p === "structured worksheet" ? (
          <span key={i} className="font-semibold text-[#111827]">
            {p}
          </span>
        ) : (
          <span key={i}>{p}</span>
        )
      )}
    </>
  )
}

function emphasizeNotesReady(text: string) {
  // Emphasis rule: “Notes are ready” can be subtly emphasised
  const parts = text.split(/(notes are ready)/gi)
  return (
    <>
      {parts.map((p, i) =>
        /notes are ready/i.test(p) ? (
          <span key={i} className="font-semibold text-[#111827]">
            {p}
          </span>
        ) : (
          <span key={i}>{p}</span>
        )
      )}
    </>
  )
}

/* -------------------------------------------------------
   SECTION 4 — Why Our Worksheets Actually Work
   Two-column explanatory section
   Left ~60%, Right ~40% worksheet visual + caption
   No heavy cards/boxes; calm academic tone; proof not marketing
-------------------------------------------------------- */

function Section4_WorksheetsProof() {
  return (
    <section className="bg-white py-14 sm:py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 lg:grid-cols-12 gap-10 lg:gap-16 items-start">
          {/* Left (Text ~60%) */}
          <div className="lg:col-span-7">
            <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
              Why Our Worksheets Actually Work
            </h2>

            <p className="mt-4 text-base sm:text-lg text-[#4B5563] leading-relaxed">
              Most aspirants struggle not because they don’t read enough — but because
              they don’t convert reading into usable notes. Our worksheets are designed
              to fix exactly that.
            </p>

            <ul className="mt-6 space-y-3 text-[15px] sm:text-[16px] text-[#374151] leading-relaxed">
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>They guide you on what to note, not everything you hear</span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>
                  They force active writing during the class, not passive watching
                </span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>
                  They organise concepts, examples, data, and dimensions in one place
                </span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>By the end of the session, your notes are already ready</span>
              </li>
            </ul>

            <p className="mt-6 text-base sm:text-lg text-[#4B5563] leading-relaxed">
              This removes confusion, delays, and scattered revision. Instead of
              revising from multiple sources, you revise from one clean worksheet per
              topic.
            </p>
          </div>

          {/* Right (Visual ~40%) */}
          <div className="lg:col-span-5">
            <div className="w-full">
              {/* Replace with ONE real worksheet page image */}
              <div className="relative w-full aspect-[3/4] rounded-2xl overflow-hidden border border-gray-100 shadow-[0_10px_25px_rgba(0,0,0,0.12)] bg-white">
                <Image
                  src="/Nankinomics- Notes cum worksheet 1 (1)-8.png" // TODO: replace with real worksheet image
                  alt="A typical Economy Weekly worksheet used during the class"
                  fill
                  className="object-cover"
                  sizes="(max-width: 1024px) 90vw, 420px"
                />
              </div>

              <p className="mt-3 text-sm text-[#6B7280]">
                A typical Economy Weekly worksheet used during the class
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------------------
   SECTION 5 — Calendar/Archive
   You said: "your calender walaa section is fine"
   So this is a placeholder to hook your existing component.
-------------------------------------------------------- */

function Section5_CalendarArchive() {
  return <WeeklyArchiveSection />;
}

/* -------------------------------------------------------
   SECTION 6 — FAQs
-------------------------------------------------------- */

function Section6_FAQs() {
  const faqs = [
    {
      q: "How is Economy Weekly different from reading newspapers like The Hindu, Indian Express, or Business Line?",
      a: "Newspapers provide information, but they don’t tell you what to study for the exam. Economy Weekly filters economic news through the UPSC lens, identifies exam-relevant dimensions, and structures them using worksheets so you don’t feel lost or overloaded.",
    },
    {
      q: "Is Economy Weekly meant for Prelims, Mains, or both?",
      a: "It is designed for both Prelims and Mains. Each issue is covered at the depth required for Prelims conceptual clarity, along with Mains-oriented dimensions, linkages, examples, and answer-writing relevance.",
    },
    {
      q: "Do I still need to follow daily economic current affairs if I attend Economy Weekly?",
      a: "No, not separately. Economy Weekly consolidates the most important economic developments of the week, so you don’t need to track multiple sources daily for economy-related current affairs.",
    },
    {
      q: "Where and when do I get the worksheets for each week?",
      a: "Worksheets are shared before the class, so you can keep them ready while watching the session. They are available through our platform (and Telegram), and are meant to be filled live during the class.",
    },
    {
      q: "Is Economy Weekly suitable for beginners who have just started UPSC preparation?",
      a: "Yes. It is especially useful for beginners who struggle with understanding economic news, identifying exam-relevant points, or making structured notes from current affairs.",
    },
    {
      q: "How much time does Economy Weekly take every week?",
      a: "Each week typically involves: One focused YouTube session (~1 hour) and filling the worksheet during the class. There is no additional note-making workload later.",
    },
  ]

  return (
    <section className="bg-white py-16 sm:py-20 border-t border-gray-100">
      <div className="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827] text-center">
          FAQs — Economy Current Affairs (Weekly)
        </h2>

        <div className="mt-10 space-y-4">
          {faqs.map((f, i) => (
            <details
              key={i}
              className="group bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-6 sm:p-7"
            >
              <summary className="cursor-pointer list-none flex items-start justify-between gap-4">
                <span className="text-[15px] sm:text-[16px] font-semibold text-[#111827] leading-relaxed">
                  {f.q}
                </span>
                <span className="mt-1 text-[#6B7280] transition-transform duration-200 group-open:rotate-180">
                  ▾
                </span>
              </summary>

              <p className="mt-4 text-[15px] sm:text-[16px] text-[#4B5563] leading-relaxed">
                {f.a}
              </p>
            </details>
          ))}
        </div>

        {/* No extra CTAs required by spec; keeping it clean */}
      </div>
    </section>
  )
}
